<?= $this->extend('templates/admin_page_layout') ?>
<?= $this->section('content') ?>

<div class="content">
<div class="container-fluid">
<div class="row">
<div class="col-lg-12 col-md-12">

<div class="card">

    <!-- ================= HEADER ================= -->
    <div class="card-header card-header-tabs card-header-primary">
        <div class="nav-tabs-navigation">
            <div class="row align-items-center">

                <div class="col-md-3">
                    <!-- <h4 class="card-title"><b>Tambah Data Siswa</b></h4> -->
                    <!-- <p class="card-category">Input data siswa baru</p> -->
                </div>

                <div class="col-md-9">
                    <ul class="nav nav-tabs" id="wizardTabs">
                        <li class="nav-item">
                            <a class="nav-link active" href="#" data-step="0">
                                <i class="material-icons">person</i> Data Utama
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link disabled" href="#" data-step="1">
                                <i class="material-icons">school</i> Kelas
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link disabled" href="#" data-step="2">
                                <i class="material-icons">call</i> Kontak
                            </a>
                        </li>
                    </ul>
                </div>

            </div>
        </div>
    </div>

    <div class="card-body"></div>
    <!-- ================= BODY ================= -->
    <div class="card-body">

        <!-- FLASH MESSAGE -->
        <?php if(session()->getFlashdata('success')): ?>
            <div class="alert alert-success"><?= session()->getFlashdata('success') ?></div>
        <?php endif; ?>

        <?php if(session()->getFlashdata('errors')): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php foreach(session()->getFlashdata('errors') as $e): ?>
                        <li><?= $e ?></li>
                    <?php endforeach ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?= base_url('admin/upload/input_siswa/save') ?>" method="post" id="wizardForm">
        <?= csrf_field() ?>

        <!-- ================= STEP 1 ================= -->
        <div class="wizard-step step-active">
            <div class="row">
                <div class="col-md-2">
                    <div class="form-group">
                        <label>NIS</label>
                        <input type="text" class="form-control" id="nis" name="nis" required>
                    </div>
                </div>
                                        <div class="card-body"></div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Unique Code</label>
                        <input type="text" class="form-control" id="unique_code" name="unique_code" readonly>
                        <!-- <small class="text-muted">Otomatis mengikuti NIS</small> -->
                    </div>
                </div>
                                        <div class="card-body"></div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>Nama Siswa</label>
                        <input type="text" class="form-control" name="nama_siswa" required>
                    </div>
                </div>
            </div>

            <div class="text-end mt-3">
                <button type="button" class="btn btn-primary next-step">
                    Lanjut <i class="material-icons">arrow_forward</i>
                </button>
            </div>

                <div class="mt-3 text-end">
                    <a href="<?= base_url('admin/menudata') ?>" 
                    class="btn btn-primary w-100" 
                    style="background-color: #9844ff; border-color: #b144ff; color: #fff;">
                        <i class="material-icons">arrow_back</i> Kembali
                    </a>
                </div>




        </div>

        <!-- ================= STEP 2 ================= -->
        <div class="wizard-step">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Jurusan</label>
                        <select class="form-control" id="id_jurusan" name="id_jurusan" required>
                            <option value="">-- Pilih Jurusan --</option>
                            <?php foreach($jurusan as $j): ?>
                                <option value="<?= $j['id'] ?>"><?= $j['jurusan'] ?></option>
                            <?php endforeach ?>
                        </select>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label>Kelas</label>
                        <select class="form-control" id="id_kelas" name="id_kelas" required>
                            <option value="">-- Pilih Kelas --</option>
                            <?php foreach($kelas as $k): ?>
                                <option value="<?= $k['id_kelas'] ?>" data-jurusan="<?= $k['id_jurusan'] ?>">
                                    <?= $k['kelas'] ?> (<?= $k['jurusan'] ?>)
                                </option>
                            <?php endforeach ?>
                        </select>
                    </div>
                </div>
            </div>
                                        <div class="card-body"></div> 
            <div class="d-flex justify-content-between mt-3">
                <button type="button" class="btn btn-secondary prev-step">
                    <i class="material-icons">arrow_back</i> Kembali
                </button>
                <button type="button" class="btn btn-primary next-step">
                    Lanjut <i class="material-icons">arrow_forward</i>
                </button>
            </div>
        </div>

        <!-- ================= STEP 3 ================= -->
        <div class="wizard-step">
            <div class="row">
                <div class="col-md-4">
                    <label>Jenis Kelamin</label>
                    <div class="form-group">
                        <div class="form-check">
                            <label class="form-check-label">
                                <input type="radio" name="jenis_kelamin" value="Laki-laki"> Laki-laki
                            </label>
                        </div>
                        <div class="form-check">
                            <label class="form-check-label">
                                <input type="radio" name="jenis_kelamin" value="Perempuan"> Perempuan
                            </label>
                        </div>
                    </div>
                </div>
    <div class="card-body"></div><div class="card-body"></div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label>No HP</label>
                        <input type="text" class="form-control" name="no_hp" required>
                    </div>
                </div>
            </div>

            <div class="d-flex justify-content-between mt-3">
                <button type="button" class="btn btn-secondary prev-step">
                    <i class="material-icons">arrow_back</i> Kembali
                </button>
                <button type="submit" class="btn btn-success">
                    <i class="material-icons">save</i> Simpan
                </button>
            </div>
        </div>

        </form>



<!-- hALAMAN -->


<hr class="mt-4">

<h5 class="mb-3"><b>Data Siswa</b></h5>
<!-- ---------------------------- -->
<div class="mb-3">
    <input type="text" class="form-control" id="searchSiswa" placeholder="🔍 Cari NIS / Nama / Kelas...">
</div>
<!-- ---------------------------- -->
<div class="card shadow-sm">
    <div class="card-body p-0">

        <div class="table-responsive">
            <table class="table table-hover table-bordered table-striped mb-0 align-middle">
                <thead class="table-primary text-center">
                    <tr>
                        <th style="width:60px;">No</th>
                        <th>NIS</th>
                        <th>Nama Siswa</th>
                        <th>Kelas</th>
                        <th>Jenis Kelamin</th>
                        <th>No HP</th>
                        <th>Kode</th>
                    </tr>
                </thead>
                <tbody>
                <?php if(!empty($siswa)): ?>
                    <?php $no = 1; ?>
                    <?php foreach($siswa as $row): ?>
                        <tr>
                            <td class="text-center"><?= $no++ ?></td>
                            <td><?= esc($row['nis']) ?></td>
                            <td><?= esc($row['nama_siswa']) ?></td>
                            <td><?= esc($row['kelas']) ?></td>
                            <td><?= esc($row['jenis_kelamin']) ?></td>
                            <td><?= esc($row['no_hp']) ?></td>
                            <td class="text-center">
                                <span class="badge bg-info text-dark">
                                    <?= esc($row['unique_code']) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="text-center text-muted py-3">
                            Belum ada data siswa
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

    </div>
</div>



<!-- hALAMAN -->


















    </div>
</div>

</div>
</div>
</div>
</div>

<style>
.wizard-step{display:none}
.wizard-step.step-active{display:block}
.nav-tabs .disabled{pointer-events:none;opacity:.5}
</style>

<script>
let step=0;
const steps=document.querySelectorAll('.wizard-step');
const tabs=document.querySelectorAll('#wizardTabs .nav-link');

function render(){
    steps.forEach((s,i)=>s.classList.toggle('step-active',i===step));
    tabs.forEach((t,i)=>{
        t.classList.toggle('active',i===step);
        t.classList.toggle('disabled',i>step);
    });
}

document.querySelectorAll('.next-step').forEach(b=>{
    b.onclick=()=>{if(step<steps.length-1){step++;render();}}
});
document.querySelectorAll('.prev-step').forEach(b=>{
    b.onclick=()=>{if(step>0){step--;render();}}
});

nis.oninput=()=>unique_code.value=nis.value;

id_jurusan.onchange=()=>{
    [...id_kelas.options].forEach(o=>{
        if(!o.value) return;
        o.style.display=o.dataset.jurusan===id_jurusan.value?'block':'none';
    });
    id_kelas.value='';
};
//.....



// ================= VALIDASI NIS DUPLIKAT FRONTEND =================

// Ambil semua NIS dari database
const existingNIS = <?= json_encode(array_column($siswa, 'nis')) ?>;

// Ambil tombol lanjut step 1 saja
const nextBtnStep1 = document.querySelector('.wizard-step .next-step');

function isNisDuplicate() {
    return existingNIS.includes(nis.value.trim());
}

// Buat elemen warning
const warning = document.createElement('small');
warning.classList.add('text-danger');
warning.style.display = 'none';
nis.parentNode.appendChild(warning);

function validateNIS() {
    if (isNisDuplicate()) {
        warning.innerText = "⚠ NIS sudah terdaftar!";
        warning.style.display = 'block';
        nextBtnStep1.disabled = true;   // ⛔ disable tombol
    } else {
        warning.style.display = 'none';
        nextBtnStep1.disabled = false;  // ✅ aktifkan kembali
    }
}

nis.addEventListener('input', validateNIS);

// Blokir submit juga (pengaman backend)
document.getElementById('wizardForm').addEventListener('submit', function(e) {
    if (isNisDuplicate()) {
        e.preventDefault();
        warning.innerText = "⚠ NIS sudah terdaftar! Tidak bisa disimpan.";
        warning.style.display = 'block';
        nis.focus();
    }
});













//....

// ================= SEARCH REALTIME =================
document.getElementById('searchSiswa').addEventListener('input', function(){
    const filter = this.value.toLowerCase();
    document.querySelectorAll('table tbody tr').forEach(row => {
        const text = row.textContent.toLowerCase();
        row.style.display = text.indexOf(filter) > -1 ? '' : 'none';
    });
});

render();
</script>



<?= $this->endSection() ?>
